from django.urls import path
from django.conf import settings
from client.views import HomeView,ServiceView,CaseView,IndustryView,ContactView,CareersView,ApplyView,AboutView,PrivacyPolicyView,TermsandConditionsView,InspiringProjectView
from django.conf.urls.static import static
from django.contrib.sitemaps import views as sitemap_views
from django.urls import path
from .sitemaps import ServiceSitemap, IndustriesSitemap, CaseStudiesSitemap, JobSitemap
from django.shortcuts import redirect
sitemaps = {
    'services': ServiceSitemap,
    'industries': IndustriesSitemap,
    'case_studies': CaseStudiesSitemap,
    'jobs': JobSitemap,
}
urlpatterns = [
    path('',HomeView.as_view(),name="Home",),
    path('service/<slug:name>',ServiceView.as_view(),name="Service"),
    path('case/<slug:name>',CaseView.as_view(),name="Case"),
    path('industry/<slug:name>',IndustryView.as_view(),name="Industry"),
    path('contact/',ContactView.as_view(),name="Contact"),
    path('careers/',CareersView.as_view(),name="Careers"),
    path('careers/apply/<slug:name>',ApplyView.as_view(),name="Apply"),
    path('about/',AboutView.as_view(),name="About"),
    path('sitemap.xml', sitemap_views.sitemap, {'sitemaps': sitemaps}, name='django.contrib.sitemaps.views.sitemap'),
    path('consultation/', lambda request: redirect('https://app.simplymeet.me/elitechainllc')),
    path('instant-inquiry/', lambda request: redirect('https://wa.me/+17862337265?text=Hi%2C%20I%20am%20interested%20in%20learning%20more%20about%20your%20services%20and%20would%20like%20to%20schedule%20a%20meeting%20to%20discuss%20how%20we%20can%20potentially%20collaborate.')),
    path('privacy-policy/',PrivacyPolicyView.as_view(), name="privacy-policy"),
    path('terms-and-conditions/',TermsandConditionsView.as_view(), name="terms-and-conditions"),
    path('remarkable-projects/',InspiringProjectView.as_view(), name="inspiring-projects"),
]
urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
