# Generated by Django 4.2.7 on 2024-11-06 18:18

import datetime
from django.db import migrations, models
import django.db.models.deletion
import froala_editor.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Contact",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("email", models.EmailField(max_length=90)),
                ("subject", models.TextField(max_length=200)),
                ("text", models.TextField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name="Remarkable_Project",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("web_address", models.URLField(blank=True, null=True)),
                ("image", models.ImageField(upload_to="remarkable_projects/")),
                ("niche", models.CharField(max_length=256)),
                ("country", models.CharField(max_length=77)),
                ("delivery_time", models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tag_name", models.CharField(max_length=90)),
            ],
        ),
        migrations.CreateModel(
            name="Service",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("title", models.CharField(max_length=180)),
                ("core_line", models.CharField(max_length=400)),
                ("date", models.DateField()),
                ("image", models.ImageField(upload_to="services/")),
                ("description", froala_editor.fields.FroalaField()),
                ("tags", models.ManyToManyField(to="client.tag")),
            ],
        ),
        migrations.CreateModel(
            name="Job",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("slug", models.SlugField(max_length=90)),
                ("short_detail", models.CharField(max_length=200)),
                ("date", models.DateField(default=datetime.datetime.now)),
                ("active", models.BooleanField(default=False)),
                ("location", models.CharField(default="Location", max_length=200)),
                ("details", froala_editor.fields.FroalaField()),
                ("tags", models.ManyToManyField(to="client.tag")),
            ],
        ),
        migrations.CreateModel(
            name="Industries",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("title", models.CharField(max_length=180)),
                ("core_line", models.CharField(max_length=400)),
                ("square_image", models.ImageField(upload_to="services/")),
                ("image", models.ImageField(upload_to="services/")),
                ("description", froala_editor.fields.FroalaField()),
                ("tags", models.ManyToManyField(to="client.tag")),
            ],
        ),
        migrations.CreateModel(
            name="CaseStudies",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("slug", models.SlugField(max_length=300)),
                ("title", models.CharField(max_length=180)),
                ("core_line", models.CharField(max_length=400)),
                ("date", models.DateField()),
                ("image", models.ImageField(upload_to="services/")),
                ("square_image", models.ImageField(upload_to="services/")),
                ("description", froala_editor.fields.FroalaField()),
                ("tags", models.ManyToManyField(to="client.tag")),
            ],
        ),
        migrations.CreateModel(
            name="Applied_User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=90)),
                ("number", models.CharField(max_length=20)),
                ("email", models.CharField(db_index=True, max_length=90)),
                ("applied_date", models.DateField(auto_now_add=True)),
                (
                    "cover_letter",
                    models.FileField(blank=True, null=True, upload_to="cover_letters/"),
                ),
                ("resume", models.FileField(upload_to="resumes/")),
                (
                    "job",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="client.job"
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="job",
            index=models.Index(fields=["name"], name="client_job_name_c6b586_idx"),
        ),
    ]
